/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.ConfigurationEntry;
import com.puzzletimer.state.ConfigurationListener;
import java.util.ArrayList;
import java.util.HashMap;

public class ConfigurationManager {
    private ArrayList<ConfigurationListener> listeners = new ArrayList();
    private HashMap<String, ConfigurationEntry> entryMap = new HashMap();

    public ConfigurationManager(ConfigurationEntry[] entries) {
        ConfigurationEntry[] configurationEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationEntry entry = configurationEntryArray[n2];
            this.entryMap.put(entry.getKey(), entry);
            ++n2;
        }
    }

    public String getConfiguration(String key) {
        return this.entryMap.get(key).getValue();
    }

    public void setConfiguration(String key, String value) {
        this.entryMap.put(key, new ConfigurationEntry(key, value));
        for (ConfigurationListener listener : this.listeners) {
            listener.configurationEntryUpdated(key, value);
        }
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }
}

