/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.Category;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.ScrambleListener;
import java.util.ArrayList;

public class ScrambleManager {
    private ArrayList<ScrambleListener> listeners = new ArrayList();
    private ScramblerProvider scramblerProvider;
    private Scrambler currentScrambler;
    private ArrayList<Scramble> queue;
    private Scramble currentScramble;

    public ScrambleManager(ScramblerProvider scramblerProvider, Scrambler scrambler) {
        this.scramblerProvider = scramblerProvider;
        this.currentScrambler = scrambler;
        this.queue = new ArrayList();
        this.currentScramble = this.currentScrambler.getNextScramble();
    }

    public void setCategory(Category category) {
        this.queue.clear();
        this.currentScrambler = this.scramblerProvider.get(category.getScramblerId());
        this.changeScramble();
        this.notifyListeners();
    }

    public Scramble[] getQueue() {
        Scramble[] queueArray = new Scramble[this.queue.size()];
        this.queue.toArray(queueArray);
        return queueArray;
    }

    public void addScrambles(Scramble[] scrambles) {
        Scramble[] scrambleArray = scrambles;
        int n = scrambles.length;
        int n2 = 0;
        while (n2 < n) {
            Scramble scramble = scrambleArray[n2];
            this.queue.add(scramble);
            ++n2;
        }
        for (ScrambleListener listener : this.listeners) {
            listener.scramblesAdded(scrambles);
        }
        this.notifyListeners();
    }

    public void removeScrambles(int[] indices) {
        Scramble[] scrambles = new Scramble[indices.length];
        int i = 0;
        while (i < scrambles.length) {
            scrambles[i] = this.queue.get(indices[i]);
            ++i;
        }
        i = 0;
        while (i < scrambles.length) {
            this.queue.remove(scrambles[i]);
            ++i;
        }
        for (ScrambleListener listener : this.listeners) {
            listener.scramblesRemoved(scrambles);
        }
        this.notifyListeners();
    }

    public void moveScramblesUp(int[] indices) {
        int i = 0;
        while (i < indices.length) {
            Scramble temp = this.queue.get(indices[i] - 1);
            this.queue.set(indices[i] - 1, this.queue.get(indices[i]));
            this.queue.set(indices[i], temp);
            ++i;
        }
        this.notifyListeners();
    }

    public void moveScramblesDown(int[] indices) {
        int i = indices.length - 1;
        while (i >= 0) {
            Scramble temp = this.queue.get(indices[i] + 1);
            this.queue.set(indices[i] + 1, this.queue.get(indices[i]));
            this.queue.set(indices[i], temp);
            --i;
        }
        this.notifyListeners();
    }

    public Scramble getCurrentScramble() {
        return this.currentScramble;
    }

    public void changeScramble() {
        if (this.queue.size() > 0) {
            this.currentScramble = this.queue.get(0);
            this.removeScrambles(new int[1]);
        } else {
            this.currentScramble = this.currentScrambler.getNextScramble();
        }
        for (ScrambleListener listener : this.listeners) {
            listener.scrambleChanged(this.currentScramble);
        }
    }

    private void notifyListeners() {
        Scramble[] queueArray = new Scramble[this.queue.size()];
        this.queue.toArray(queueArray);
        for (ScrambleListener listener : this.listeners) {
            listener.scrambleQueueUpdated(queueArray);
        }
    }

    public void addScrambleListener(ScrambleListener listener) {
        this.listeners.add(listener);
    }

    public void removeScrambleListener(ScrambleListener listener) {
        this.listeners.remove(listener);
    }
}

