/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.Timing;
import com.puzzletimer.state.TimerListener;
import com.puzzletimer.timer.Timer;
import java.util.ArrayList;

public class TimerManager {
    private ArrayList<TimerListener> listeners = new ArrayList();
    private Timer currentTimer = null;

    public void setTimer(Timer timer) {
        if (this.currentTimer != null) {
            this.currentTimer.stop();
        }
        this.currentTimer = timer;
        if (timer != null) {
            for (TimerListener listener : this.listeners) {
                listener.timerChanged(timer);
            }
            this.currentTimer.start();
        }
    }

    public void leftHandPressed() {
        for (TimerListener listener : this.listeners) {
            listener.leftHandPressed();
        }
    }

    public void leftHandReleased() {
        for (TimerListener listener : this.listeners) {
            listener.leftHandReleased();
        }
    }

    public void rightHandPressed() {
        for (TimerListener listener : this.listeners) {
            listener.rightHandPressed();
        }
    }

    public void rightHandReleased() {
        for (TimerListener listener : this.listeners) {
            listener.rightHandReleased();
        }
    }

    public void timerReady() {
        for (TimerListener listener : this.listeners) {
            listener.timerReady();
        }
    }

    public void timerRunning(Timing timing) {
        for (TimerListener listener : this.listeners) {
            listener.timerRunning(timing);
        }
    }

    public void timerStopped(Timing timing) {
        for (TimerListener listener : this.listeners) {
            listener.timerStopped(timing);
        }
    }

    public void addTimerListener(TimerListener listener) {
        this.listeners.add(listener);
    }

    public void removeTimerListener(TimerListener listener) {
        this.listeners.remove(listener);
    }
}

