/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.statistics;

import com.puzzletimer.models.Solution;
import com.puzzletimer.statistics.Mean;
import com.puzzletimer.statistics.StatisticalMeasure;

public class BestMean
implements StatisticalMeasure {
    private int minimumWindowSize;
    private int maximumWindowSize;
    private int windowPosition;
    private long value;

    public BestMean(int minimumWindowSize, int maximumWindowSize) {
        this.minimumWindowSize = minimumWindowSize;
        this.maximumWindowSize = maximumWindowSize;
    }

    @Override
    public int getMinimumWindowSize() {
        return this.minimumWindowSize;
    }

    @Override
    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    @Override
    public int getWindowPosition() {
        return this.windowPosition;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setSolutions(Solution[] solutions) {
        Mean mean = new Mean(this.minimumWindowSize, this.minimumWindowSize);
        long bestMean = Long.MAX_VALUE;
        int i = 0;
        while (i < solutions.length - this.minimumWindowSize + 1) {
            Solution[] window = new Solution[this.minimumWindowSize];
            int j = 0;
            while (j < this.minimumWindowSize) {
                window[j] = solutions[i + j];
                ++j;
            }
            mean.setSolutions(window);
            if (mean.getValue() < bestMean) {
                bestMean = mean.getValue();
                this.windowPosition = i;
            }
            ++i;
        }
        this.value = bestMean;
    }
}

