/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.statistics;

import com.puzzletimer.models.Solution;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.util.SolutionUtils;

public class Mean
implements StatisticalMeasure {
    private int minimumWindowSize;
    private int maximumWindowSize;
    private long value;

    public Mean(int minimumWindowSize, int maximumWindowSize) {
        this.minimumWindowSize = minimumWindowSize;
        this.maximumWindowSize = maximumWindowSize;
    }

    @Override
    public int getMinimumWindowSize() {
        return this.minimumWindowSize;
    }

    @Override
    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    @Override
    public int getWindowPosition() {
        return 0;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setSolutions(Solution[] solutions) {
        long[] times = SolutionUtils.realTimes(solutions, false);
        long sum = 0L;
        long[] lArray = times;
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            if (time == Long.MAX_VALUE) {
                this.value = Long.MAX_VALUE;
                return;
            }
            sum += time;
            ++n2;
        }
        this.value = sum / (long)solutions.length;
    }
}

