/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.timer;

import com.puzzletimer.models.Timing;
import com.puzzletimer.state.TimerManager;
import com.puzzletimer.timer.Timer;
import com.puzzletimer.timer.TimerState;
import com.puzzletimer.timer.TimerStateListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.TimerTask;
import javax.swing.JFrame;

public class KeyboardTimer
implements Timer,
TimerStateListener,
KeyListener {
    private TimerManager timerManager;
    private JFrame parent;
    private int keyCode;
    private Date start;
    private java.util.Timer repeater;
    private TimerState state;

    public KeyboardTimer(TimerManager timerManager, JFrame parent, int keyCode) {
        this.timerManager = timerManager;
        this.parent = parent;
        this.keyCode = keyCode;
        this.start = null;
        this.state = new TimerState();
    }

    @Override
    public String getTimerId() {
        if (this.keyCode == 17) {
            return "KEYBOARD-TIMER-CONTROL";
        }
        if (this.keyCode == 32) {
            return "KEYBOARD-TIMER-SPACE";
        }
        return null;
    }

    @Override
    public void start() {
        this.state.addEventListener(this);
        this.parent.addKeyListener(this);
    }

    @Override
    public void stop() {
        if (this.repeater != null) {
            this.repeater.cancel();
        }
        this.state.removeEventListener(this);
        this.parent.removeKeyListener(this);
    }

    @Override
    public void timerStarted() {
        this.start = new Date();
        this.timerManager.timerReady();
        this.repeater = new java.util.Timer();
        this.repeater.schedule(new TimerTask(){

            @Override
            public void run() {
                Timing timing = new Timing(KeyboardTimer.this.start, new Date());
                KeyboardTimer.this.timerManager.timerRunning(timing);
            }
        }, 0L, 5L);
    }

    @Override
    public void timerStopped() {
        this.repeater.cancel();
        Timing timing = new Timing(this.start, new Date());
        this.timerManager.timerStopped(timing);
        this.timerManager.timerReady();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == this.keyCode) {
            switch (keyEvent.getKeyLocation()) {
                case 2: {
                    this.timerManager.leftHandPressed();
                    this.state.pressLeftButton();
                    break;
                }
                case 3: {
                    this.timerManager.rightHandPressed();
                    this.state.pressRightButton();
                    break;
                }
                default: {
                    this.timerManager.leftHandPressed();
                    this.state.pressLeftButton();
                    this.timerManager.rightHandPressed();
                    this.state.pressRightButton();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == this.keyCode) {
            switch (keyEvent.getKeyLocation()) {
                case 2: {
                    this.timerManager.leftHandReleased();
                    this.state.releaseLeftButton();
                    break;
                }
                case 3: {
                    this.timerManager.rightHandReleased();
                    this.state.releaseRightButton();
                    break;
                }
                default: {
                    this.timerManager.leftHandReleased();
                    this.state.releaseLeftButton();
                    this.timerManager.rightHandReleased();
                    this.state.releaseRightButton();
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

