/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.timer;

import com.puzzletimer.models.Timing;
import com.puzzletimer.state.TimerManager;
import com.puzzletimer.timer.StackmatTimerReader;
import com.puzzletimer.timer.StackmatTimerReaderListener;
import com.puzzletimer.timer.Timer;
import java.util.Date;
import java.util.TimerTask;
import javax.sound.sampled.TargetDataLine;

public class StackmatTimer
implements StackmatTimerReaderListener,
Timer {
    private TimerManager timerManager;
    private StackmatTimerReader stackmatTimerReader;
    private Date timingStart;
    private java.util.Timer repeater;
    private boolean ready;

    public StackmatTimer(TimerManager timerManager, TargetDataLine targetDataLine) {
        this.timerManager = timerManager;
        this.stackmatTimerReader = new StackmatTimerReader(targetDataLine);
        this.timingStart = null;
        this.ready = false;
        this.stackmatTimerReader.addEventListener(this);
        this.repeater = new java.util.Timer();
        this.repeater.schedule(new TimerTask(){

            @Override
            public void run() {
                if (StackmatTimer.this.ready && StackmatTimer.this.timingStart != null) {
                    Timing timing = new Timing(StackmatTimer.this.timingStart, new Date());
                    StackmatTimer.this.timerManager.timerRunning(timing);
                }
            }
        }, 0L, 5L);
    }

    @Override
    public String getTimerId() {
        return "STACKMAT-TIMER";
    }

    @Override
    public void dataReceived(byte[] data) {
        if (data[0] == 65 || data[0] == 67 || data[0] == 76) {
            this.timerManager.leftHandPressed();
        }
        if (data[0] == 32 || data[0] == 73 || data[0] == 82 || data[0] == 83) {
            this.timerManager.leftHandReleased();
        }
        if (data[0] == 65 || data[0] == 67 || data[0] == 82) {
            this.timerManager.rightHandPressed();
        }
        if (data[0] == 32 || data[0] == 73 || data[0] == 76 || data[0] == 83) {
            this.timerManager.rightHandReleased();
        }
        int minutes = data[1] - 48;
        int seconds = 10 * (data[2] - 48) + data[3] - 48;
        int centiseconds = 10 * (data[4] - 48) + data[5] - 48;
        long time = 60000 * minutes + 1000 * seconds + 10 * centiseconds;
        Date end = new Date();
        Date start = new Date(end.getTime() - time);
        Timing timing = new Timing(start, end);
        if (data[0] == 32) {
            this.timingStart = start;
        } else if (data[0] == 65 || data[0] == 73 || data[0] == 83) {
            this.timingStart = null;
        }
        if (data[0] == 65 || data[0] == 73) {
            this.ready = true;
            this.timerManager.timerReady();
        } else if (this.ready && (data[0] == 32 || data[0] == 76 || data[0] == 82)) {
            this.timerManager.timerRunning(timing);
        } else if (data[0] == 83 && this.ready) {
            this.ready = false;
            this.timerManager.timerStopped(timing);
        }
    }

    @Override
    public void start() {
        Thread readerThread = new Thread(this.stackmatTimerReader);
        readerThread.start();
    }

    @Override
    public void stop() {
        this.stackmatTimerReader.removeEventListener(this);
        this.stackmatTimerReader.stop();
        this.repeater.cancel();
    }
}

