/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.timer;

import com.puzzletimer.timer.StackmatTimerReaderListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.TargetDataLine;

class StackmatTimerReader
implements Runnable {
    private double sampleRate;
    private double period;
    private TargetDataLine targetDataLine;
    private ArrayList<StackmatTimerReaderListener> listeners;
    private boolean running;

    StackmatTimerReader(TargetDataLine targetDataLine) {
        this.sampleRate = targetDataLine.getFormat().getFrameRate();
        this.period = this.sampleRate / 1200.0;
        this.targetDataLine = targetDataLine;
        this.listeners = new ArrayList();
        this.running = false;
    }

    private byte[] readPacket(byte[] samples, int offset, byte bitThreshold) {
        byte[] data = new byte[9];
        int i = 0;
        while (i < 9) {
            if (samples[offset + (int)((double)(10 * i) * this.period)] <= bitThreshold) {
                return new byte[9];
            }
            data[i] = 0;
            int j = 0;
            while (j < 8) {
                if (samples[offset + (int)((double)(10 * i + j + 1) * this.period)] > bitThreshold) {
                    int n = i;
                    data[n] = (byte)(data[n] | 1 << j);
                }
                ++j;
            }
            if (samples[offset + (int)((double)(10 * i + 9) * this.period)] > bitThreshold) {
                return new byte[9];
            }
            ++i;
        }
        return data;
    }

    private boolean isValidPacket(byte[] data) {
        int sum = 0;
        int i = 1;
        while (i < 6) {
            sum += data[i] - 48;
            ++i;
        }
        return " ACILRS".contains(String.valueOf((char)data[0])) && Character.isDigit(data[1]) && Character.isDigit(data[2]) && Character.isDigit(data[3]) && Character.isDigit(data[4]) && Character.isDigit(data[5]) && data[6] == sum + 64 && data[7] == 10 && data[8] == 13;
    }

    private byte[] inverted(byte[] data) {
        byte[] invertedData = new byte[data.length];
        int i = 0;
        while (i < invertedData.length) {
            invertedData[i] = ~data[i];
            ++i;
        }
        return invertedData;
    }

    @Override
    public void run() {
        this.running = true;
        this.targetDataLine.start();
        byte[] buffer = new byte[(int)(this.sampleRate / 4.0)];
        int offset = buffer.length;
        while (this.running) {
            int i = offset;
            while (i < buffer.length) {
                buffer[i - offset] = buffer[i];
                ++i;
            }
            this.targetDataLine.read(buffer, buffer.length - offset, offset);
            boolean isPacketStart = false;
            boolean isSignalInverted = false;
            offset = 0;
            block2: while ((double)offset + 0.119171 * this.sampleRate < (double)buffer.length) {
                int threshold = 0;
                while (threshold < 256) {
                    byte[] data = this.readPacket(buffer, offset, (byte)(threshold - 127));
                    if (this.isValidPacket(data)) {
                        isPacketStart = true;
                        break block2;
                    }
                    if (this.isValidPacket(this.inverted(data))) {
                        isPacketStart = true;
                        isSignalInverted = true;
                        break block2;
                    }
                    ++threshold;
                }
                ++offset;
            }
            if (!isPacketStart) continue;
            HashMap<Long, Integer> packetHistogram = new HashMap<Long, Integer>();
            int i2 = 0;
            while ((double)i2 < this.period) {
                int threshold = 0;
                while (threshold < 256) {
                    byte[] data = this.readPacket(buffer, offset + i2, (byte)(threshold - 127));
                    if (isSignalInverted) {
                        data = this.inverted(data);
                    }
                    if (this.isValidPacket(data)) {
                        long packet = 0L;
                        int j = 0;
                        while (j < 6) {
                            packet |= (long)data[j] << 8 * j;
                            ++j;
                        }
                        if (packetHistogram.containsKey(packet)) {
                            packetHistogram.put(packet, (Integer)packetHistogram.get(packet) + 1);
                        } else {
                            packetHistogram.put(packet, 1);
                        }
                    }
                    ++threshold;
                }
                ++i2;
            }
            long packet = 0L;
            int highestFrequency = 0;
            for (Map.Entry entry : packetHistogram.entrySet()) {
                if ((Integer)entry.getValue() <= highestFrequency) continue;
                packet = (Long)entry.getKey();
                highestFrequency = (Integer)entry.getValue();
            }
            byte[] data = new byte[9];
            int i3 = 0;
            while (i3 < 6) {
                data[i3] = (byte)(packet >> 8 * i3);
                ++i3;
            }
            for (StackmatTimerReaderListener listener : this.listeners) {
                listener.dataReceived(data);
            }
            offset = (int)((double)offset + 0.119171 * this.sampleRate);
        }
        this.targetDataLine.close();
    }

    public void stop() {
        this.running = false;
    }

    public void addEventListener(StackmatTimerReaderListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(StackmatTimerReaderListener listener) {
        this.listeners.remove(listener);
    }
}

