/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.timer;

import com.puzzletimer.timer.TimerStateListener;
import java.util.ArrayList;

class TimerState {
    private boolean readyToStart = true;
    private boolean running = false;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private ArrayList<TimerStateListener> listeners = new ArrayList();

    public void pressLeftButton() {
        this.pressButton(true);
    }

    public void releaseLeftButton() {
        this.releaseButton(true);
    }

    public void pressRightButton() {
        this.pressButton(false);
    }

    public void releaseRightButton() {
        this.releaseButton(false);
    }

    private void pressButton(boolean leftButton) {
        if (leftButton) {
            this.leftPressed = true;
        } else {
            this.rightPressed = true;
        }
        if (this.running && this.leftPressed && this.rightPressed) {
            this.running = false;
            for (TimerStateListener listener : this.listeners) {
                listener.timerStopped();
            }
        }
    }

    private void releaseButton(boolean leftButton) {
        if (leftButton) {
            this.leftPressed = false;
        } else {
            this.rightPressed = false;
        }
        if (this.readyToStart && !this.running && this.leftPressed != this.rightPressed) {
            this.readyToStart = false;
            this.running = true;
            for (TimerStateListener listener : this.listeners) {
                listener.timerStarted();
            }
        }
        if (!(this.readyToStart || this.running || this.leftPressed || this.rightPressed)) {
            this.readyToStart = true;
        }
    }

    public void addEventListener(TimerStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(TimerStateListener listener) {
        this.listeners.remove(listener);
    }
}

