/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.tips;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.solvers.RubiksCubeCrossSolver;
import com.puzzletimer.solvers.RubiksCubeSolver;
import com.puzzletimer.tips.Tipper;
import com.puzzletimer.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class RubiksCubeTipper
implements Tipper {
    @Override
    public String getPuzzleId() {
        return "RUBIKS-CUBE";
    }

    @Override
    public String getTips(Scramble scramble) {
        StringBuilder tip = new StringBuilder();
        tip.append("3OP cycles:\n  ");
        RubiksCubeSolver.State cubeState = RubiksCubeSolver.State.id.applySequence(scramble.getSequence());
        int[] nArray = new int[8];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[6] = 5;
        nArray[7] = 4;
        int[] cornersOrder = nArray;
        for (ArrayList<Byte> cycle : this.cycles(cornersOrder, cubeState.cornersPermutation)) {
            if (cycle.size() < 2) continue;
            String[] cornerNames = new String[]{"UBL", "UBR", "UFR", "UFL", "DBL", "DBR", "DFR", "DFL"};
            tip.append("(" + cornerNames[cycle.get(0)]);
            int i = 1;
            while (i < cycle.size()) {
                tip.append(" " + (String)cornerNames[cycle.get(i)]);
                ++i;
            }
            tip.append(")");
        }
        tip.append("\n  ");
        int[] nArray2 = new int[12];
        nArray2[0] = 6;
        nArray2[1] = 7;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 3;
        nArray2[6] = 1;
        nArray2[7] = 2;
        nArray2[8] = 10;
        nArray2[9] = 11;
        nArray2[10] = 8;
        nArray2[11] = 9;
        int[] edgesOrder = nArray2;
        for (ArrayList arrayList : this.cycles(edgesOrder, cubeState.edgesPermutation)) {
            if (arrayList.size() < 2) continue;
            String[] edgeNames = new String[]{"BL", "BR", "FR", "FL", "UB", "UR", "UF", "UL", "DB", "DR", "DF", "DL"};
            tip.append("(" + edgeNames[(Byte)arrayList.get(0)]);
            int i = 1;
            while (i < arrayList.size()) {
                tip.append(" " + edgeNames[(Byte)arrayList.get(i)]);
                ++i;
            }
            tip.append(")");
        }
        tip.append("\n\n");
        RubiksCubeCrossSolver.State state = RubiksCubeCrossSolver.State.id.applySequence(scramble.getSequence());
        tip.append("Optimal cross:\n");
        String[][] stringArray = RubiksCubeCrossSolver.solve(state);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] solution = stringArray[n2];
            tip.append("  " + StringUtils.join(" ", this.applyX2(solution)) + "\n");
            ++n2;
        }
        return tip.toString().trim();
    }

    private ArrayList<ArrayList<Byte>> cycles(int[] order, byte[] permutation) {
        boolean[] visited = new boolean[permutation.length];
        int i = 0;
        while (i < visited.length) {
            visited[i] = false;
            ++i;
        }
        ArrayList<ArrayList<Byte>> cycles = new ArrayList<ArrayList<Byte>>();
        int i2 = 0;
        while (i2 < permutation.length) {
            if (!visited[order[i2]]) {
                ArrayList<Byte> cycle = new ArrayList<Byte>();
                byte current = (byte)order[i2];
                do {
                    cycle.add(current);
                    visited[current] = true;
                } while ((current = permutation[current]) != (Byte)cycle.get(0));
                cycles.add(cycle);
            }
            ++i2;
        }
        return cycles;
    }

    private String[] applyX2(String[] sequence) {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("U", "D");
        table.put("U2", "D2");
        table.put("U'", "D'");
        table.put("D", "U");
        table.put("D2", "U2");
        table.put("D'", "U'");
        table.put("L", "L");
        table.put("L2", "L2");
        table.put("L'", "L'");
        table.put("R", "R");
        table.put("R2", "R2");
        table.put("R'", "R'");
        table.put("F", "B");
        table.put("F2", "B2");
        table.put("F'", "B'");
        table.put("B", "F");
        table.put("B2", "F2");
        table.put("B'", "F'");
        String[] newSequence = new String[sequence.length + 1];
        newSequence[0] = "x2";
        int i = 1;
        while (i < newSequence.length) {
            newSequence[i] = (String)table.get(sequence[i - 1]);
            ++i;
        }
        return newSequence;
    }
}

