/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.util;

import com.puzzletimer.models.Solution;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SolutionUtils {
    public static String formatSeconds(long time) {
        if (time == Long.MAX_VALUE) {
            return "DNF";
        }
        String sign = "";
        if (time < 0L) {
            sign = "-";
            time = -time;
        }
        return String.valueOf(sign) + String.format("%d.%02d", time / 1000L, time % 1000L / 10L);
    }

    public static String formatMinutes(long time) {
        if (time == Long.MAX_VALUE) {
            return "DNF";
        }
        String sign = "";
        if (time < 0L) {
            sign = "-";
            time = -time;
        }
        return String.valueOf(sign) + String.format("%02d:%02d.%02d", time / 60000L, time % 60000L / 1000L, time % 1000L / 10L);
    }

    public static long parseTime(String input) {
        Pattern pattern = Pattern.compile("\\s*(\\d+):(\\d+)\\.(\\d{1,2})\\s*");
        Matcher matcher = pattern.matcher(input);
        if (matcher.matches()) {
            long time = 0L;
            time += (long)(60000 * Integer.parseInt(matcher.group(1)));
            time += (long)(1000 * Integer.parseInt(matcher.group(2)));
            int fraction = Integer.parseInt(matcher.group(3));
            return time += (long)(fraction < 10 ? 100 * fraction : 10 * fraction);
        }
        pattern = Pattern.compile("\\s*(\\d+):(\\d+)\\s*");
        matcher = pattern.matcher(input);
        if (matcher.matches()) {
            long time = 0L;
            time += (long)(60000 * Integer.parseInt(matcher.group(1)));
            return time += (long)(1000 * Integer.parseInt(matcher.group(2)));
        }
        pattern = Pattern.compile("\\s*(\\d+)\\.(\\d{1,2})\\s*");
        matcher = pattern.matcher(input);
        if (matcher.matches()) {
            long time = 0L;
            time += (long)(1000 * Integer.parseInt(matcher.group(1)));
            int fraction = Integer.parseInt(matcher.group(2));
            return time += (long)(fraction < 10 ? 100 * fraction : 10 * fraction);
        }
        pattern = Pattern.compile("\\s*(\\d+)\\s*");
        matcher = pattern.matcher(input);
        if (matcher.matches()) {
            return 1000 * Integer.parseInt(matcher.group(1));
        }
        return 0L;
    }

    public static long realTime(Solution solution) {
        if (solution.getPenalty().equals("DNF")) {
            return Long.MAX_VALUE;
        }
        if (solution.getPenalty().equals("+2")) {
            return solution.getTiming().getElapsedTime() + 2000L;
        }
        return solution.getTiming().getElapsedTime();
    }

    public static long[] realTimes(Solution[] solutions, boolean filterDNF) {
        ArrayList<Long> realTimes = new ArrayList<Long>();
        int i = 0;
        while (i < solutions.length) {
            long actualTime = SolutionUtils.realTime(solutions[i]);
            if (!filterDNF || actualTime != Long.MAX_VALUE) {
                realTimes.add(actualTime);
            }
            ++i;
        }
        long[] realTimesArray = new long[realTimes.size()];
        int i2 = 0;
        while (i2 < realTimesArray.length) {
            realTimesArray[i2] = (Long)realTimes.get(i2);
            ++i2;
        }
        return realTimesArray;
    }
}

