
// Functions for reading the puzzle definition.
#include <vector>
#include <set>

#include "data.h"

#ifndef RULES_H
#define RULES_H

using namespace std;

class rules {
   public:
      rules(string);
      void print(void); // For debuging
      map<string, dataset> getDatasets();
      map<string, substate> getSolved();
      map<string, map<string, submove> > getMoves();
      vector<movepair> getForbiddenPairs();
      map<string, substate> getIgnore();
      set<map<string, set<int> > > getBlocks();
   private:
      string name; // The name of the puzzle
      map<string, dataset> datasets; // Size and properties of the state-data
//      vector<PuzzleState> solved_states; // The solved state(s) of the puzzle
//      vector< map<string, substate > > solved_states;
      map<string, substate> solved;
      map<string, substate> ignore; // 0 = solve piece, 1 = dont solve piece
      map<string, map<string, submove> > moves; // Possible moves of the puzzle
      vector<movepair> forbidden;
      set<map<string, set<int> > > blocks;
};

#endif
